#include <iostream>
#include <vector>
#include <algorithm>
#include <climits>

int main() {
    // Unos dimenzija matrice i podmatrica
    long long N, M, K, L;
    std::cin >> N >> M >> K >> L;

    // Unos niza A
    std::vector<long long> A(N * M);
    for (long long i = 0; i < N * M; i++) {
        std::cin >> A[i];
    }

    // Konverzija niza A u matricu
    std::vector<std::vector<long long>> matrixA(N, std::vector<long long>(M));
    for (long long i = 0; i < N; i++) {
        for (long long j = 0; j < M; j++) {
            matrixA[i][j] = A[i * M + j];
        }
    }

    // Pronalaženje najveceg broja
    long long max = LLONG_MIN;
    long long maxRowIndex = 0;
    long long maxColIndex = 0;
    for (long long i = 0; i < N; i++) {
        for (long long j = 0; j < M; j++) {
            if (matrixA[i][j] > max) {
                max = matrixA[i][j];
                maxRowIndex = i;
                maxColIndex = j;
            }
        }
    }

    // Premestanje najveceg broja u središnju matricu
    long long tmp = matrixA[N / 2][M / 2];
    matrixA[N / 2][M / 2] = max;
    matrixA[maxRowIndex][maxColIndex] = tmp;

    // Sortiranje svakog reda matrice tako da je najveci broj na poziciji M/2
    std::vector<std::vector<long long>> sortedMatrix(N, std::vector<long long>(M));
    for (long long i = 0; i < N; i++) {
        std::sort(matrixA[i].begin(), matrixA[i].end());
        long long idx = M / 2;
        for (long long j = 0; j < M; j++) {
            sortedMatrix[i][j] = matrixA[i][(j + idx) % M];
        }
    }

    // Podela matrice na podmatrice dimenzija KxL
    std::vector<std::vector<std::vector<long long>>> submatrices(N - K + 1, std::vector<std::vector<long long>>(M - L + 1, std::vector<long long>(K * L)));
    for (long long i = 0; i < N - K + 1; i++) {
        for (long long j = 0; j < M - L + 1; j++) {
            for (long long k = 0; k < K; k++) {
                for (long long l = 0; l < L; l++) {
                    submatrices[i][j][k * L + l] = sortedMatrix[i + k][j + l];
                }
            }
        }
    }

    // Sabiranje svih podmatrica
    long long totalSum = 0;
    for (long long i = 0; i < N - K + 1; i++) {
        for (long long j = 0; j < M - L + 1; j++) {